
CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_especial_cliente(
	integer, 
	integer, 
	integer, 
	integer, 
	integer
)
RETURNS SETOF public.rs_tab_desc_prod AS
$body$
--declara as variaveis usadas na funcao
declare

-- versão 17/09/2020 
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_prod             alias for $3;
int_cd_cli              alias for $4;
int_usa_desconto_propz_ident ALIAS FOR $5;

	
---------------------------------------------------------
---fim
---------------------------------------------------------
var_tipodescontocliente 	integer;


returnrec rs_tab_desc_prod; --recebera os dados de retorno da funcao
--declarando variavel para teste da flag 
begin --inicio dos blocos da funcao
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_tab_desc_prod
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone  
		);
		exception when others then
		truncate table temp_rs_tab_desc_prod; -- trunca a tabela se ela já existir na corrente sessão.
	end;

	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_prod
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_prod; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;



		
	var_tipodescontocliente =coalesce((select coalesce(valor,'0')::integer from  prc_emp_config where cd_chave = 'TIPO_DESCONTO_LISTA_DE_PRODUTOS_CLIENTE' ), 0);					
	

    -- lista especifica 
 	if var_tipodescontocliente = 0 then 
	       
	insert into temp_rs_tab_desc_prod     
		 select    
				0             as cd_tbl_desc,    
				28            as tp_desc,    
				0             as flag_desc_fix,    
				perc_desc     as perc_desc,    
				perc_desc     as perc_desc_max,    
				1             as tp_nivel,
				current_date  as dt_ini      
		   from rc_cli_est_prod a 
		        join rc_cli b on a.cd_emp = b.cd_emp 
		                     and a.cd_cli = b.cd_cli 
		                   
		   where int_cd_emp    = a.cd_emp 
             and int_cd_prod   = a.cd_prod
             and int_cd_cli    = a.cd_cli;
	end if; 	   	  
	   	  


	-- lista por tabela de desconto 
	if var_tipodescontocliente = 1 then 

	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
		
	insert into rs_est_prod_arv_merc		
	select 
		   arv.cd_emp					,
		   arv.cd_prod					,
		   arv.cd_arv_merc_categ		,
		   arv.cd_arv_merc_linha		,
		   arv.cd_mc					,
		   arv.cd_arv_merc_familia		,												
		   p.cd_fabric 
	  from est_prod_est_arv_mercadologica arv 
	       inner join est_prod p on arv.cd_emp		= p.cd_emp
								and arv.cd_prod = p.cd_prod
	 where arv.cd_emp  = int_cd_emp
	   and arv.cd_prod = int_cd_prod;
	  
	  
	 if exists (select 1 from rs_est_prod_arv_merc) then
		 

	   insert into rs_tab_ativa_prod    
			select  a.cd_emp,    
					a.cd_tbl_desc,    
					a.cd_tp_desconto
			  from est_prod_tbl_desc a 
				   inner join est_prod_tbl_desc_prc_filial fil on a.cd_emp      = fil.cd_emp 
															  and a.cd_tbl_desc = fil.cd_tbl_desc
				   inner join est_prod_tbl_desc_rc_cli c on a.cd_tbl_desc = c.cd_tbl_desc
											            and a.cd_emp      = c.cd_emp
	
			  where	int_cd_emp    = a.cd_emp 
			   	and current_date between date(a.dt_ini) and date(a.dt_fim)
				and 1  = a.sts_tbl_desc 
				and 28 = a.cd_tp_desconto 
				and int_cd_cli = c.cd_cli
				AND	(
				  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
				  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
				);  

	 
		if exists (select 1 from rs_tab_ativa_prod) then
		
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_prod     
				select    
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,    
						1 as tp_nivel,
					    a.dt_ini      
				from est_prod_tbl_desc a    
					 inner join est_prod_tbl_desc_rc_cli b on a.cd_emp      = b.cd_emp 
												          and a.cd_tbl_desc = b.cd_tbl_desc    
					 inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp      = fil.cd_emp 
																and b.cd_tbl_desc = fil.cd_tbl_desc    
					 inner join rs_tab_ativa_prod rs_tab_ativa_prod on b.cd_emp       = rs_tab_ativa_prod.cd_emp 
																   and b.cd_tbl_desc = rs_tab_ativa_prod.cd_tbl_desc     
					 inner join rs_est_prod_arv_merc arv on b.cd_emp  = arv.cd_emp 
														and b.cd_prod = arv.cd_prod
																												
			   where int_cd_prod   = b.cd_prod
			     and int_cd_cli    = b.cd_cli;
		 end if     ;
	       
	   	   
	  end if; 
	   	   
	 end if;	  
	   	  
 
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	for returnrec in 
		select cd_tbl_desc, 
		       tp_desc, 
		       flag_desc_fix, 
		       perc_desc, 
		       perc_desc_max, 
		       tp_nivel 
		  from temp_rs_tab_desc_prod 
		 --order by tp_nivel asc, perc_desc desc, dt_ini desc limit 1
		 order by  dt_ini desc, tp_nivel asc, perc_desc desc limit 1
	loop
		return next returnrec;
	end loop;				
end; --fim dos blocos da funcao
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_especial_cliente(integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_prod AS
$body$
DECLARE RET rs_tab_desc_prod;
BEGIN
  RET = ufd_est_prod_tbl_desc_especial_cliente($1, $2, $3, $4, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;